# Время
Чтобы максимально оптимизировать методы работы, нужно понять, как измеряется время в игре. С этим как раз поможет данная технология.

## Новые функции
Есть две полезные функции для измерения времени, затрачиваемого на те или иные действия.

`get_time()` возвращает время в секундах с начала игры.

`get_tick_count()` возвращает количество тиков, прошедших с начала выполнения кода.

Эти две функции, а также `quick_print()`, ничего не стоят. И операция вызова тоже!

## Детали выполнения

### Внимание
Производительность в реальном мире работает иначе. В игре действуют особые правила, позволяющие создать последовательную и понятную модель времени.
Скорее всего, тебя это заинтересует, только если ты захочешь максимально оптимизировать код.


Основная единица времени для выполнения кода называется «тик». Если не используются повышение скорости и энергия, выполнение происходит со скоростью `400` тиков в секунду.

В основном операции, комбинирующие два значения, такие как `+, -, *, /, //, %, and, or, ...`, занимают один тик.
Унарный минус `-` и `not` не занимают время.
Ветвление `if` также занимает 1 тик (в дополнение ко времени, необходимому для вычисления выражения условия).
Вызовы функций, а также чтение и запись переменных не занимают время, но определение функций занимает 1 тик.
Инструкции `import` не занимают время.
Доступ к импортированному модулю через оператор `.` не занимает время.
Если функция или модуль переданы через аргументы или присваивание переменной, их использование стоит 1 тик вместо 0.
Запуск циклов `for` и `while` занимает 1 тик, но ты ничего не тратишь на итерации (не считая времени на вычисление выражений условия/последовательности).
`return`, `break` и `continue` не занимают время.
`pass` занимает 1 тик, так что его можно использовать для создания точных задержек.
Индексация в структуре данных занимает 1 тик для оператора индексации, а в случае со словарем или множеством может потребовать больше тиков в зависимости от размера ключа.

Количество тиков, которое занимают встроенные функции, задокументировано отдельно для каждой функции.